/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/* Definitions for kernel piece of program to dump kernel memory */

/*
 * $Id: kdump-kern.h,v 1.2 2001/09/28 20:45:48 wyllie Exp $
 *
 * $Log: kdump-kern.h,v $
 * Revision 1.2  2001/09/28 20:45:48  wyllie
 * Add kdump commands to give formatted dumps of the Linux task_struct and
 * various virtual memory structures.
 *
 * Revision 1.1  2001/03/16 21:07:34  wyllie
 * Program to dump kernel memory by address or symbol on a running system.
 * Can also get formatted dumps of some kernel data structures.
 *
 */

/* Routine to initialize stuff needing access to kernel declarations */
extern void KernInit();

/* Read routines for various types of kernel objects.  Read the object at the
   given address and copy it into malloc'ed storage.  Return the address of
   the allocated object, or NULL if the object could not be read. */
extern void* GenericGet(unsigned long addr, int len);
extern void* GetDentry(unsigned long addr);
extern void* GetInode(unsigned long addr);
extern void* GetSuperBlock(unsigned long addr);
extern void* GetPage(unsigned long addr);
extern void* GetAddressSpace(unsigned long addr);
extern void* GetVMAreaStruct(unsigned long addr);
extern void* GetMMStruct(unsigned long addr);
extern void* GetTaskStruct(unsigned long addr);
extern void* GetTaskStructByPID(unsigned long pid, unsigned long * addrP);
extern void VirtToReal(unsigned long pgdAddr, unsigned long vaddr);

/* Free routines for kernel objects.  Object types not listed here can
   be freed with CondFree. */
extern void FreeDentry(void* p);

/* Print routines for various types of kernel objects.  Parameter may be NULL. */
extern void PrintDentry(void* parm, unsigned long addr);
extern void PrintInode(void* parm, unsigned long addr);
extern void PrintSuperBlock(void* parm, unsigned long addr);
extern void PrintCxiNode_t(void* parm, unsigned long addr);
extern void PrintPage(void* parm, unsigned long addr);
extern void PrintAddressSpace(void* parm, unsigned long addr);
extern void PrintVMAreaStruct(void* parm, unsigned long addr);
extern void PrintMMStruct(void* parm, unsigned long addr);
extern void PrintTaskStruct(void* parm, unsigned long addr);

